//  Copyright (C) 2000 Tridia Corporation. All Rights Reserved.
//  Copyright (C) 1999 AT&T Laboratories Cambridge. All Rights Reserved.
//
//  This file is part of the VNC system.
//
//  The VNC system is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
//  USA.
//
// TightVNC distribution homepage on the Web: http://www.tightvnc.com/
//
// If the source code for the VNC system is not available from the place 
// whence you received this file, check http://www.uk.research.att.com/vnc or contact
// the authors on vnc@uk.research.att.com for information on obtaining it.

// ZLIB Encoding
//
// The bits of the ClientConnection object to do with zlib.
#include <pspkernel.h>
#include <string.h>
#include "pspnet.h"
#include "vnc.h"
#include "lzo/minilzo.h"

extern int rfbsock;

typedef struct {
    CARD32 nBytes;
} rfbZlibHeader;
#define sz_rfbZlibHeader 4

CARD8 m_netbuf[0x80000];
CARD8 m_zlibbuf[0x80000];

#define CheckBufferSize(x) if(x>sizeof(m_netbuf)) return false;
#define CheckZlibBufferSize(x) if(x>sizeof(m_zlibbuf)) return false;
#define Check_Rectangle_borders(x,y,w,h)

int ReadUltraRect(rfbFramebufferUpdateRectHeader *pfburh) {
  unsigned int numpixels = pfburh->r.w * pfburh->r.h;
  // this assumes at least one byte per pixel. Naughty.
  unsigned int numRawBytes = numpixels * 2;
  unsigned int numCompBytes;
  unsigned int new_len;

  rfbZlibHeader hdr;

  // Read in the rfbZlibHeader
//  omni_mutex_lock l(m_bitmapdcMutex);
  ReadExact(rfbsock, (CARD8 *)&hdr, sz_rfbZlibHeader);

  numCompBytes = Swap32IfLE(hdr.nBytes);
  // Read in the compressed data
  CheckBufferSize(numCompBytes);

  ReadExact(rfbsock, m_netbuf, numCompBytes);
  CheckZlibBufferSize(numRawBytes);

  lzo1x_decompress((CARD8*)m_netbuf,numCompBytes,(CARD8*)m_zlibbuf,&new_len,NULL);
//  SoftCursorLockArea(pfburh->r.x, pfburh->r.y,pfburh->r.w,pfburh->r.h);
  Check_Rectangle_borders(pfburh->r.x, pfburh->r.y,pfburh->r.w,pfburh->r.h);

  CopyDataToScreen((CARD16*)m_zlibbuf, pfburh->r.x, pfburh->r.y, pfburh->r.w,pfburh->r.h);

//  if (m_DIBbits) 
//    ConvertAll(pfburh->r.w,pfburh->r.h,pfburh->r.x, pfburh->r.y,
//               m_myFormat.bitsPerPixel/8, (CARD8 *)m_zlibbuf,
//               (CARD8 *)m_DIBbits,m_si.framebufferWidth);
  return true;
}

int ReadUltraZip(rfbFramebufferUpdateRectHeader *pfburh) {
  unsigned int nNbCacheRects = pfburh->r.x;
  unsigned int numRawBytes = pfburh->r.y+pfburh->r.w*65535;
  unsigned int numCompBytes;
  unsigned int new_len;
  int i;
  rfbZlibHeader hdr;

  // Read in the rfbZlibHeader
//  omni_mutex_lock l(m_bitmapdcMutex);
  ReadExact(rfbsock, (CARD8 *)&hdr, sz_rfbZlibHeader);
  numCompBytes = Swap32IfLE(hdr.nBytes);

  // Check the net buffer
  CheckBufferSize(numCompBytes);

  // Read the compressed data
  ReadExact(rfbsock, (CARD8 *)m_netbuf, numCompBytes);

  // Verify buffer space for cache rects list
  CheckZlibBufferSize(numRawBytes+500);

  lzo1x_decompress((CARD8*)m_netbuf,numCompBytes,(CARD8*)m_zlibbuf,&new_len,NULL);
  CARD8* pzipbuf = m_zlibbuf;
  for (i = 0 ; i < nNbCacheRects; i++)
  {
    rfbFramebufferUpdateRectHeader surh;
    memcpy((char *) &surh,pzipbuf, sz_rfbFramebufferUpdateRectHeader);
    surh.r.x = Swap16IfLE(surh.r.x);
    surh.r.y = Swap16IfLE(surh.r.y);
    surh.r.w = Swap16IfLE(surh.r.w);
    surh.r.h = Swap16IfLE(surh.r.h);
    surh.encoding = Swap32IfLE(surh.encoding);
    pzipbuf += sz_rfbFramebufferUpdateRectHeader;

    //border check
    Check_Rectangle_borders(surh.r.x,surh.r.y,surh.r.w,surh.r.h);

//    SoftCursorLockArea(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    
    if ( surh.encoding==rfbEncodingRaw)
    {
      unsigned int numpixels = surh.r.w * surh.r.h;                
      CopyDataToScreen((CARD16*)pzipbuf, surh.r.x, surh.r.y, surh.r.w,surh.r.h);
//      if (m_DIBbits) ConvertAll(surh.r.w,surh.r.h,surh.r.x, surh.r.y,m_myFormat.bitsPerPixel/8,(CARD8 *)pzipbuf,(CARD8 *)m_DIBbits,m_si.framebufferWidth);
      pzipbuf +=numpixels*2;
//      InvalidateRegion(&rect,prgn);
    }
  }
  return true;
}
