typedef unsigned char CARD8, Bool, Byte;
typedef unsigned short CARD16, Word;
typedef unsigned long CARD32;

#define false 0
#define true 1
#define False 0
#define True 1

#ifndef BIGENDIAN
#define Swap16IfLE(s) htons(s)
#define Swap32IfLE(l) htonl(l)
#else
#define Swap16IfLE(s) (s)
#define Swap32IfLE(l) (l)
#endif

#define MAX_ENCODINGS 10

#include "rfbproto.h"

typedef rfbRectangle RectangleType;

#define VNC_DATA_PORT_NR                5900

#define SCROLLBAR_SIZE                  8
#define VIEWPORT_H                  272
#define VIEWPORT_W                  480
#define VIEWPORT_SKEW			512

/* defines boudaries of the PSP viewport */
typedef struct {
  rfbRectangle  desktop;        // Dimensions of unscaled desktop
  CARD16 scaleFactor; // Scale factor for current viewport
  rfbRectangle  viewable;       // what is visible
  rfbRectangle  virtual;        // what is in the off-screen window
  rfbRectangle  remote;         // what is on the server side
  rfbRectangle  zoomarea;       // specified zoom coordinates
  Bool          zoomarea_ena; // Use specified zoom coordinates
} PRFBViewport;

typedef struct {
  char name[32];                // VNC server display name
  CARD32 address;             // VNC server address (IP)
  CARD16 port;                   // VNC port number
  char password[32];            // VNC password   
  CARD16 beginX;        // initial coordinate X on the desktop
  CARD16 beginY;
  CARD16 scaleFactor; // Default scale factor
  Bool sharedDesktop;        // share desktop with other viewer?
  char loginNameNT[32];         // user name used to login into a NT VNC
  char passwNT[32];             // a password for that
} DB_ServerConnection;

extern PRFBViewport pspFB;
extern DB_ServerConnection server;


/* rfbproto.c */

extern Bool useBGR233;
extern Bool debug;
extern int rfbsock;
extern rfbPixelFormat myFormat;
extern rfbServerInitMsg si;
extern Bool sendUpdateRequest;
extern Bool updateViewportSize;

extern Bool ConnectToRFBServer(CARD32 host, int port);
extern Bool InitialiseRFBConnection();
extern Bool SetScaleFactor(CARD16 scaleFactor);
extern Bool SetFormatAndEncodings();
extern Bool SendIncrementalFramebufferUpdateRequest();
extern Bool SendFramebufferUpdateRequest(int x, int y, int w, int h, int incremental);
extern Bool SendPointerEvent(int x, int y, int buttonMask);
extern Bool SendKeyEvent(CARD32 key, int down);
extern Bool SendClientCutText(char *str, int len);
extern Bool HandleRFBServerMessage();
extern Bool GetPassword(char* password, int maxlength);


/* vnc.c */
extern void CopyDataToScreen(CARD16 *buf, short x, short y, CARD16 width, CARD16 height);
extern void DrawVirtualFilledRectangle (CARD16 colorIndex,
                                short x, short y,
                                CARD16 w, CARD16 h,
                                int adjust);

extern void UpdateProgress (char *msg, int part, int whole);

/* sockets.c */

// Set default timeout
#define SelectNetTimeout (sysTicksPerSecond / 10) /* Used for Select */
#define ConnectNetTimeout (sysTicksPerSecond * 10) /* Used for ConnectTcpAddr */
#define ReadNetTimeout (sysTicksPerSecond * 30) /* Used for ReadExact */

extern Bool errorMessageFromReadExact;
extern void PrintSentRecvStat (void); 
extern Bool ReadExact (int sock, unsigned char *buf, int n);
extern Bool WriteExact (int sock, unsigned char *buf, int n);
extern int ConnectToTcpAddr (unsigned long host, int port);  
extern int StringToIPAddr (char *str, unsigned long *addr);  

extern int ReadRawRect(rfbFramebufferUpdateRectHeader *pfburh);
extern int ReadSolidRect(rfbFramebufferUpdateRectHeader *pfburh);
extern int ReadRRERect(rfbFramebufferUpdateRectHeader *pfburh);
extern int ReadCoRRERect(rfbFramebufferUpdateRectHeader *pfburh);
extern int ReadUltraZip(rfbFramebufferUpdateRectHeader *pfburh);
extern int ReadUltraRect(rfbFramebufferUpdateRectHeader *pfburh);

