#include <pspkernel.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include "pg.h"
#include "dialog.h"

extern int bQuit;

extern u16 _menubmp[];
extern u16 _splashbmp[];
u16 *bBitmap = _menubmp;

void dlg_frame(const char *msg0, const char *msg1)
{
  int x, i;
    
  bltrect br = { 0, 0, 480, 255, 512, 256, _menubmp, 1, GE_TPSM_8888 };
  pgBitBltR(&br, 0, 17);

  // CACbCZA[CWBHBG
  if(msg0) mh_print(17, 17, msg0, WHITE);
//  pgDrawFrame(17,25,463,248,GREY);
//  pgDrawFrame(18,26,462,247,GREY);
  // Q@MlP>
  if(msg1) {
    x = (479-(strlen(msg1)*5))/2;
    for(i=0; msg1[i]; i++) if((msg1[i] & 0xf0) == 0x80) x-=5;
    mh_print(x, 271-16, msg1, WHITE);
  }
}

u8 GREY32[32] = {
  0x00, 0x10, 0x20, 0x30, 0x40, 0x50, 0x60, 0x70,
  0x80, 0x90, 0xa0, 0xb0, 0xc0, 0xd0, 0xe0, 0xf0,
  0xf0, 0xe0, 0xd0, 0xc0, 0xb0, 0xa0, 0x90, 0x80,
  0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10, 0x00,
};

int MessageBox(const char *msg, int type){
  int f=0, c;
  int MsgSel = 0;
  bltrect br = { 0, 0, 480, 255, 512, 256, _menubmp, 1, GE_TPSM_8888 };

  while(!bQuit) {

    readpad(0);

    if(new_pad & (PSP_CTRL_LEFT | PSP_CTRL_RIGHT)) MsgSel = !MsgSel;
    if(new_pad & (PSP_CTRL_CROSS | PSP_CTRL_CIRCLE)) { readpad(0); return MsgSel; }
    if((new_pad & (PSP_CTRL_SQUARE | PSP_CTRL_TRIANGLE)) && type) { readpad(0); return 0; }

    pgStartFrame();

    pgBitBltR(&br, 0, 17);

    mh_print(240-63, 271-15, " /  Enter   /  Back", BLACK);
    mh_print(240-64, 271-16, " /  Enter   /  Back", WHITE);

//    x = (479-(strlen(msg)*5))/2;
//    mh_print(x,97,msg, BLACK);
//    mh_print(x,96,msg, WHITE);

    f++;
    c = AY8(GREY32[f&0x1f], GREY32[f&0x1f]);

    if(type) {
      if(MsgSel) {
        pgFillBox(122, 122, 242, 146, c);
      } else {
        pgFillBox(248, 122, 368, 146, c);
      }

      mh_print(279, 126, "\tCancel", BLACK);
      mh_print(278, 125, "\tCancel", WHITE);
      mh_print(173, 126, "\tOk", BLACK);
      mh_print(172, 125, "\tOk", WHITE);
    } else {
      pgFillBox(204, 122, 276, 146, c);
      mh_print(231, 126, "\tOk", BLACK);
      mh_print(230, 125, "\tOk", WHITE);
    }

    mh_print(28,32,msg,WHITE);
    pgEndFrame();
  }
  readpad(0);
  return 0;
}

void PostProgressMessage(const char *msg, u16 curr, u16 max){
    u32 c=curr, m=max;
    bltrect br = { 0, 0, 480, 255, 512, 256, _splashbmp, 1, GE_TPSM_8888 };

    pgStartFrame();

    pgBitBltR(&br, 0, 17);
    mh_print(4,34,msg,WHITE);

    if(m) {
     pgDrawFrame(242, 34, 478, 50, GREY);
     pgFillBox(244, 36, 244+(232*c)/m, 48, WHITE);
    }

    pgEndFrame();
}

char Keys[2][6][13][16] = { {
{
 "Esc", "", "F1", "", "F2", "", "F3", "", "F4", "", "F5", "", "F6"
}, {
 "`", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", "="
}, {
 "q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "[", "]", " Backspace"
}, {
 "a", "s", "d", "f", "g", "h", "j", "k", "l", ";", "'", "", "   Enter"
}, {
 "z", "x", "c", "v", "b", "n", "m", ",", ".", "/", "Shift", "", "  Delete"
}, {
 "Ctrl","", "Alt","", "Space","",  "",  "",  "Tab",  "", "\\", "", "   Abort"
}
 }, {
{
 "Esc", "", "F7", "", "F8", "", "F9", "", "F10", "", "F11", "", "F12"
}, {
 "~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "+"
}, {
 "Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "{", "}", " Backspace"
}, {
 "A", "S", "D", "F", "G", "H", "J", "K", "L", ":", "\"", "", "   Enter"
}, {
 "Z", "X", "C", "V", "B", "N", "M", "<", ">", "?", "Shift", "", "  Delete"
}, {
 "Ctrl","", "Alt","", "Space","",  "",  "", "Tab", "", "|", "", "   Abort"
}
 } };

u8 Spacing[6][13] = { {
 2, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2
}, {
 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
}, {
 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3
}, {
 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 3
}, {
 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 3
}, {
 2, 0, 2, 0, 4, 0, 0, 0, 2, 0, 1, 0, 3
} };

u8 KeyCodes[2][6][13] = { { {
 27,  0, 0xf1,  0, 0xf2,  0, 0xf3,  0, 0xf4,  0, 0xf5,  0, 0xf6
}, {
 '`', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '='
}, {
 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '[', ']', 8
}, {
 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', '\'', 0, 13
}, {
 'z', 'x', 'c', 'v', 'b', 'n', 'm', ',', '.', '/', 0xfe, 0, 127
}, {
 0xfd,  0, 0xf0,   0, ' ',   0,   0,   0,  '\t',  0, '\\', 0, 255
} }, { {
 27,  0, 0xf7,  0, 0xf8,  0, 0xf9,  0, 0xfa,  0, 0xfb,  0, 0xfc
}, {
 '~', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+'
}, {
 'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '{', '}', 8
}, {
 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', ':', '"',   0, 13
}, {
 'Z', 'X', 'C', 'V', 'B', 'N', 'M', '<', '>', '?', 0xfe,  0, 127
}, {
 0xfd,  0, 0xf0,   0, ' ',   0,   0,   0, '\t',  0, '|',  0, 255
} } };

int VKB_InputText(char *Banner, char *outbuffer, int len) {
  int x, y, d=-1, f=0;
  int VKB_x = 0, VKB_y = 0, VKB_s = 0;
  int VKB_Done = 0, shift = 0;
  char tbuf[512], *obuf = tbuf+1;
  
  if(len>500) len = 500;
  
  tbuf[0] = '\t';
  memcpy(tbuf+1, outbuffer, len);
  tbuf[len] = 0;

  while(!VKB_Done && !bQuit) {
    f++;

    pgStartFrame();

    dlg_frame(Banner," /  Select");
    mh_print(32,42,tbuf, WHITE);
    mh_print(32+VKB_s*10,62,"\t^", RED);
    for(y=0; y<6; y++) {
      for(x=0; x<13; x++) {
        if(Keys[shift][y][x][0] != 0) {
          int c = WHITE, cx = BLACK;
          int fx = x*20+40;
          int fy = y*20+130;
          int s = Spacing[y][x];

          if(y>=2 && x>=12) fx+=48;
          else fx+=y*8;

          if((VKB_x==x) && (VKB_y==y)) {
            c = RED;
            cx = AY8(GREY32[f&0x1f]/2, GREY32[f&0x1f]/2);
          }

          pgFillBox(fx, fy, fx+(26*s)-8, fy+18, cx);
          pgDrawFrame(fx, fy, fx+(26*s)-7, fy+19, c);
          pgDrawFrame(fx+1, fy+1, fx+(26*s)-11, fy+15, c);

          if((x>=11) && (y!=1)) fx+=2;

          mh_print(fx+6, fy+4, Keys[shift][y][x], c);
        } else {
          if((VKB_x==x) && (VKB_y==y)) VKB_x++;
        }
      }
    }

    pgEndFrame();
    readpad(0);

    if(new_pad & PSP_CTRL_DOWN) { d=-1; VKB_y++; }
    if(new_pad & PSP_CTRL_UP) { d=-1; VKB_y--; }
    if(new_pad & PSP_CTRL_LEFT) { d=-1; VKB_x--; }
    if(new_pad & PSP_CTRL_RIGHT) { d=1; VKB_x++; }

    if(new_pad & PSP_CTRL_LTRIGGER) VKB_s--;
    if(new_pad & PSP_CTRL_RTRIGGER) VKB_s++;

    if(VKB_s<0) VKB_s=0;
    if(VKB_s>strlen(obuf)) VKB_s=strlen(obuf);

    if(VKB_x<0) VKB_x=12;
    if(VKB_y<0) VKB_y=5;
    if(VKB_x>=13) VKB_x=0;
    if(VKB_y>=6) VKB_y=0;

    while(!KeyCodes[shift][VKB_y][VKB_x]) {
      VKB_x+=d;
      if(VKB_x<0) VKB_x=12;
      if(VKB_x>=13) VKB_x=0;
    }

    if(new_pad & (PSP_CTRL_CIRCLE | PSP_CTRL_CROSS)) {
      if(!Keys[shift][VKB_y][VKB_x][1]) {
          if(KeyCodes[shift][VKB_y][VKB_x]) {
            obuf[VKB_s] = KeyCodes[shift][VKB_y][VKB_x];
            VKB_s++;
          }
      } else {
        switch(KeyCodes[shift][VKB_y][VKB_x]) {
         case 0xf0: case 0xf1: case 0xf2: case 0xf3: case 0xf4: case 0xf5:
         case 0xf6: case 0xf7: case 0xf8: case 0xf9: case 0xfa: case 0xfb:
         case 0xfc: case 0xfd:
          break;
         case 13:
          VKB_Done=2;
          break;
         case 255:
          VKB_Done=1;
          break;
         case 8:
          if(VKB_s) {
            strcpy(obuf + VKB_s-1, obuf + VKB_s);
            VKB_s--;
          }
          break;
         case 127:
          if(strlen(obuf)) {
            strcpy(obuf + VKB_s, obuf + VKB_s+1);
          }
          break;
         case 254:
          shift=!shift;
          break;
         default:
          if(KeyCodes[shift][VKB_y][VKB_x]) {
            obuf[VKB_s] = KeyCodes[shift][VKB_y][VKB_x];
            VKB_s++;
          }
          break;
        }
      }
    }
    if(new_pad & PSP_CTRL_SQUARE) {
      shift=!shift;
    };
    if(new_pad & PSP_CTRL_START) {
      return 2;
    };

  }

  memcpy(outbuffer, tbuf+1, len);

  return (VKB_Done==2);
}

int VKB_Overlay(int px, int py, int *Vx, int *Vy, int *Vs, int *Vd, int Vc, int Va) {
  int x, y, d=*Vd;
  int VKB_x = *Vx, VKB_y = *Vy, shift = *Vs;

  if(d==0) d=-1;

  for(y=0; y<6; y++) {
    for(x=0; x<13; x++) {
      if(Keys[shift][y][x][0] != 0) {
        u32 c, cx;
        int fx = x*20+px;
        int fy = y*20+py;
        int s = Spacing[y][x];

        if(y>=2 && x>=12) fx+=48;
        else fx+=y*8;

        if((KeyCodes[shift][y][x]==0xfd) && Vc) {
          c = RGB888(64,64,128);
          cx= RGB888(32,32,64);
        } else if((KeyCodes[shift][y][x]==0xf0) && Va) {
          c = RGB888(64,64,128);
          cx= RGB888(32,32,64);
        } else if((VKB_x==x) && (VKB_y==y)) {
          c = RGB888(255,0,0);
          cx = RGB888(64,16,16);
        } else {
          c = AY8(0xcc,0xcc);
          cx=AY8(0xcc,0);
        }

        pgFillBox(fx, fy, fx+(26*s)-8, fy+18, cx);
        pgDrawFrame(fx, fy, fx+(26*s)-7, fy+19, c);
        pgDrawFrame(fx+1, fy+1, fx+(26*s)-11, fy+15, c);

        if((x>=11) && (y!=1)) fx+=2;

        mh_print(fx+6, fy+4, Keys[shift][y][x], c);
      } else {
        if((VKB_x==x) && (VKB_y==y)) VKB_x++;
      }
    }
  }

  if(new_pad & PSP_CTRL_DOWN) { d=-1; VKB_y++; }
  if(new_pad & PSP_CTRL_UP) { d=-1; VKB_y--; }
  if(new_pad & PSP_CTRL_LEFT) { d=-1; VKB_x--; }
  if(new_pad & PSP_CTRL_RIGHT) { d=1; VKB_x++; }

  if(VKB_x<0) VKB_x=12;
  if(VKB_y<0) VKB_y=5;
  if(VKB_x>=13) VKB_x=0;
  if(VKB_y>=6) VKB_y=0;

  while(!KeyCodes[shift][VKB_y][VKB_x]) {
    VKB_x+=d;
    if(VKB_x<0) VKB_x=12;
    if(VKB_x>=13) VKB_x=0;
  }

  if(new_pad & (PSP_CTRL_CIRCLE | PSP_CTRL_CROSS)) {
    switch(KeyCodes[shift][VKB_y][VKB_x]) {
      case 254:
        *Vs = !shift;
        return 0;
      default:
        if(KeyCodes[shift][VKB_y][VKB_x])
          return KeyCodes[shift][VKB_y][VKB_x];
    }
  }

  if(new_pad & PSP_CTRL_SQUARE) {
    *Vs=!shift;
  };
  if(new_pad & PSP_CTRL_START) {
    return 13;
  };

  *Vx = VKB_x;
  *Vy = VKB_y;
  *Vd = d;
  return 0;
}

int MsgPrintf(int type, char *fmt, ...) {
  va_list opt;
  
  char buff[2048];
  int bufsz;
  
  va_start(opt, fmt);
  bufsz = vsnprintf( buff, (size_t) sizeof(buff), fmt, opt);
  buff[bufsz] = 0;

  if(type==2) { 
    PostProgressMessage(buff, 0, 0);
    return 0;
  } else
    return MessageBox(buff, type);
}
