#include <pspkernel.h>
#include <pspiofilemgr_fcntl.h>
#include <pspiofilemgr_dirent.h>
#include "pg.h"
#include <string.h>
#include "dialog.h"

#define MAXPATH 512
#define MAXNAME 256
#define MAXNODES 2048

char VNCPath[MAXPATH];

SceIoDirent files[MAXNODES];
SceIoDirent *sortfiles[MAXNODES];
int nfiles;

u32 FilerColor[4] = { BLACK, GREY, WHITE, GREY };

////////////////////////////////////////////////////////////////////////
// NCbN\[g
// AC add start
void SJISCopy(SceIoDirent *a, unsigned char *file)
{
	unsigned char ca;
	int i;
	int len=strlen(a->d_name);
	
	for(i=0;i<=len;i++){
		ca = a->d_name[i];
		if (((0x81 <= ca)&&(ca <= 0x9f))
		|| ((0xe0 <= ca)&&(ca <= 0xef))){
			file[i++] = ca;
			file[i] = a->d_name[i];
		}
		else{
			if(ca>='a' && ca<='z') ca-=0x20;
			file[i] = ca;
		}
	}

}
int cmpFile(SceIoDirent *a, SceIoDirent *b)
{
    unsigned char file1[0x108];
    unsigned char file2[0x108];
	unsigned char ca, cb;
	int i, n, ret;

	if(a->d_stat.st_attr==b->d_stat.st_attr){
		SJISCopy(a, file1);
		SJISCopy(b, file2);
		n=strlen((char*)file1);
		for(i=0; i<=n; i++){
			ca=file1[i]; cb=file2[i];
			ret = ca-cb;
			if(ret!=0) return ret;
		}
		return 0;
	}
	
	if(FIO_S_ISDIR(a->d_stat.st_attr))		return -1;
	else					return 1;
}
// AC add end

void sort_files(SceIoDirent **a, int left, int right) {
	SceIoDirent *tmp, *pivot;
	int i, p;
	
	if (left < right) {
		pivot = a[left];
		p = left;
		for (i=left+1; i<=right; i++) {
			if (cmpFile(a[i],pivot)<0){
				p=p+1;
				tmp=a[p];
				a[p]=a[i];
				a[i]=tmp;
			}
		}
		a[left] = a[p];
		a[p] = pivot;
		sort_files(a, left, p-1);
		sort_files(a, p+1, right);
	}
}
////////////////////////////////////////////////////////////////////////

void getDir(const char *path) {
	int fd, b=0;
//	char *p;
	
	nfiles = 0;
	
	if(strcmp(path,"ms0:/")){
		strcpy(files[nfiles].d_name,"..");
		files[nfiles].d_stat.st_attr = FIO_S_IFDIR;
		sortfiles[nfiles] = files + nfiles;
		nfiles++;
		b=1;
	}
	
	fd = sceIoDopen(path);
	while(nfiles<MAXNODES){
		memset(&files[nfiles], 0x00, sizeof(SceIoDirent));
		if(sceIoDread(fd, &files[nfiles])<=0) break;
		if(files[nfiles].d_name[0] == '.') continue;
		if(FIO_S_ISDIR(files[nfiles].d_stat.st_attr)){
			strcat(files[nfiles].d_name, "/");
			sortfiles[nfiles] = files + nfiles;
			nfiles++;
		}else {
			sortfiles[nfiles] = files + nfiles;
			nfiles++;
		}
	}
	sceIoDclose(fd);
	if(b)
		sort_files(sortfiles+1, 0, nfiles-2);
	else
		sort_files(sortfiles, 0, nfiles-1);
}

char filer_msg[256]={0};
int getFilePath(char *out)
{
	unsigned long color;
	static int sel=0;
	int top, rows=21, x, y, h, i, up=0, oldDirType;
	char path[MAXPATH], oldDir[MAXNAME], tmp[MAXPATH*2], *p;
	
	top = sel-3;
	strcpy(path, VNCPath);
	strcat(path, "Hosts");
	
	getDir(path);
	for(;;){
		readpad();
		if(new_pad)
			filer_msg[0]=0;
		if(new_pad & (CTRL_CIRCLE | CTRL_CROSS)){
			if(FIO_S_ISDIR(sortfiles[sel]->d_stat.st_attr)){
				if(!strcmp(sortfiles[sel]->d_name,"..")){
					up=1;
				}else{
					strcat(path,sortfiles[sel]->d_name);
					getDir(path);
					sel=0;
				}
			}else{
				strcpy(tmp,path);
				strcat(tmp,sortfiles[sel]->d_name);
				break;
			}
		}else if(new_pad & CTRL_SQUARE){
			return 0;
		}else if(new_pad & CTRL_SELECT){
			if(FIO_S_ISREG(sortfiles[sel]->d_stat.st_attr)){
				strcpy(tmp,"\"");
				strcat(tmp,sortfiles[sel]->d_name);
				strcat(tmp,"\"\n\nRemove?");
				if(MessageBox(tmp,1)){
					strcpy(tmp, path);
					strcat(tmp, sortfiles[sel]->d_name);
					if(sceIoRemove(tmp)>=0){
						strcpy(filer_msg,"Removed \"");
						strcat(filer_msg,sortfiles[sel]->d_name);
						strcat(filer_msg,"\"");
						getDir(path);
					}
				}
			}
		}else if(new_pad & CTRL_TRIANGLE){
			up=1;
		}else if(new_pad & CTRL_UP){
			sel--;
		}else if(new_pad & CTRL_DOWN){
			sel++;
		}else if(new_pad & CTRL_LEFT){
			sel-=rows/2;
		}else if(new_pad & CTRL_RIGHT){
			sel+=rows/2;
		}
		
		if(up){
			oldDir[0]=0;
			oldDirType = FIO_S_IFDIR;
			if(strcmp(path,"ms0:/")){
				if(FIO_S_ISDIR(oldDirType))
					path[strlen(path)-1]=0;
				p=strrchr(path,'/')+1;
				strcpy(oldDir,p);
				if(FIO_S_ISDIR(oldDirType))
					strcat(oldDir,"/");
				*p=0;
				getDir(path);
				sel=0;
			}
			for(i=0; i<nfiles; i++) {
				if(oldDirType==sortfiles[i]->d_stat.st_attr
				&& !strcmp(oldDir, sortfiles[i]->d_name)) {
					sel=i;
					top=sel-3;
					break;
				}
			}
			up=0;
		}
		
		if(top > nfiles-rows)	top=nfiles-rows;
		if(top < 0)				top=0;
		if(sel >= nfiles)		sel=nfiles-1;
		if(sel < 0)				sel=0;
		if(sel >= top+rows)		top=sel-rows+1;
		if(sel < top)			top=sel;
		
		pgStartFrame();
		
		dlg_frame(filer_msg[0]?filer_msg:path," / ~ Enter   Back   Up   SELECT Remove");
		
		// XN[o[
		if(nfiles > rows){
			h = 219;
			pgDrawFrame(445,25,446,248,FilerColor[1]);
			pgFillBox(448, h*top/nfiles + 27,
				460, h*(top+rows)/nfiles + 27,FilerColor[1]);
		}
		
		x=28; y=32;
		for(i=0; i<rows; i++){
			if(top+i >= nfiles) break;
			if(top+i == sel) color = FilerColor[2];
			else			 color = FilerColor[3];
			mh_print(x, y, sortfiles[top+i]->d_name, color);
			y+=10;
		}
		
		pgEndFrame();
	}
	
	strcpy(out, path);
	strcat(out, sortfiles[sel]->d_name);
	return 1;
}
