#include <pspkernel.h>
#include <pspiofilemgr_fcntl.h>
#include <pspiofilemgr_dirent.h>
#include "vncdbg.h"
#include "pg.h"
#include "filer.h"
#include "dialog.h"
#include <string.h>
#include <malloc.h>
#include <stdio.h>
#include "libvnc/vnc.h"

#define MAXPATH 512
#define MAXNAME 256

extern void vncMain();

extern int bQuit, bDisconnected;
extern char VNCPath[MAXPATH];
char hostpath[MAXPATH];

void LoadOptions();
void SaveOptions();
void vncOptions();

#define ICONLIST

#ifdef ICONLIST
#define ICONSIZE (64*64*2)
extern u16 _disicon[ICONSIZE/2];
extern u16 _vkbicon[ICONSIZE/2];
extern u16 _dpadicon[ICONSIZE/2];
extern u16 _mouseicon[ICONSIZE/2];
extern u16 _scrollicon[ICONSIZE/2];
extern u16 _newicon[ICONSIZE/2];
extern u16 _unkicon[ICONSIZE/2];
extern u16 _xbxicon[ICONSIZE/2];
extern u16 _tuxicon[ICONSIZE/2];
extern u16 _macicon[ICONSIZE/2];
extern u16 _winicon[ICONSIZE/2];
extern u16 _opticon[ICONSIZE/2];
extern u16 _neticon[ICONSIZE/2];
extern u16 _homeicon[ICONSIZE/2];
extern u16 _check[ICONSIZE/2];
extern u16 _nocheck[ICONSIZE/2];
extern u16 _five[ICONSIZE/2];
extern u16 _ten[ICONSIZE/2];
extern u16 _fifteen[ICONSIZE/2];
extern u16 _twenty[ICONSIZE/2];
extern u16 _gauge1[ICONSIZE/2];
extern u16 _gauge2[ICONSIZE/2];
extern u16 _gauge3[ICONSIZE/2];
extern u16 _gauge4[ICONSIZE/2];
extern u16 _gauge5[ICONSIZE/2];
extern u16 _menusel[ICONSIZE/2];
int pickicon=0;

u16 *gauge[5] = {
  _gauge1, _gauge2, _gauge3, _gauge4, _gauge5
};

typedef struct {
  u32 host;
  u16 port;
  u16 mode;
  char name[MAXNAME];
  u8 dummy[248];
  u16 icon[ICONSIZE/2];
} hostent;

#define M_Host 0
#define M_NewHost 1
#define M_Options 2
#define M_Networks 3

#define MAXICON 16
hostent __attribute__((aligned(16))) Icon[MAXICON];

u16 *IP_i = NULL;
int HostCount=0;
#endif

#define UPPER_THRESHOLD  0xcf
#define LOWER_THRESHOLD  0x2f

char hostfn[32] = "";
u32 IP_h = 0xc0a80001;
u16 IP_p = 5900;
s8 IP_s = 0, IP_Done;

#ifndef ICONLIST
void LoadHost(char *path) {
  int fd;
  char temppath[MAXPATH];
 
  if(!path) return;
  
  if(strncmp("ms0:", path, 3)) {
    strcpy(temppath, VNCPath);
    strcat(temppath, path);
  } else
    strcpy(temppath, path);

//  MsgPs1("Loading:\n  ", temppath, "", 0);

  fd = sceIoOpen(temppath, PSP_O_RDONLY, 0777);
  IP_h = 0; IP_p = 0;
  sceIoRead(fd, &IP_h, 4);
  sceIoRead(fd, &IP_p, 2);
  sceIoClose(fd);
}
#else
void LoadHost(u8 index) {
  IP_h = Icon[index].host;
  IP_p = Icon[index].port;
  strcpy(hostfn, Icon[index].name);
}
void LoadHostFile(int x) {
  char fn[MAXPATH];
  strcpy(fn, VNCPath);
  strcat(fn, "Hosts/");
  strcat(fn, Icon[x].name);
  memcpy(Icon[x].icon, _unkicon, ICONSIZE);
  int fd = sceIoOpen(fn, PSP_O_RDONLY, 0777);
  if(fd) {
    sceIoRead(fd, &Icon[x].host, 4);
    sceIoRead(fd, &Icon[x].port, 2);
    sceIoRead(fd, &Icon[x].name, MAXNAME);
    sceIoRead(fd, &Icon[x].icon, ICONSIZE);
    sceIoClose(fd);
  }
}
void LoadHosts() {
  int fd, x;
  SceIoDirent de;
  char hostfiles[MAXPATH];

  pgStartFrame();
  pgEndFrame();
  
  strcpy(hostfiles, VNCPath);
  strcat(hostfiles, "Hosts");

  HostCount=0;

  strcpy(Icon[HostCount].name, "Options");
  Icon[HostCount].mode = M_Options;
  Icon[HostCount].host = 0;
  Icon[HostCount].port = 0;
  memcpy(Icon[HostCount].icon, _opticon, ICONSIZE);
  HostCount++;

  fd = sceIoDopen(hostfiles);
  if(fd) {
    while(HostCount < MAXICON-2) {
      memset(&de, 0x00, sizeof(SceIoDirent));
      if(sceIoDread(fd, &de)<=0) break;
      if(de.d_name[0] == '.') continue;
      if(!FIO_S_ISDIR(de.d_stat.st_attr)) {
        strcpy(Icon[HostCount].name, de.d_name);
        Icon[HostCount].mode = M_Host;
        HostCount++;
      }
    }
    sceIoDclose(fd);
  }
  for(x=1; x<HostCount; x++) {
    LoadHostFile(x);
  }

  strcpy(Icon[HostCount].name, "New Host");
  Icon[HostCount].mode = M_NewHost;
  Icon[HostCount].host = 0;
  Icon[HostCount].port = 0;
  memcpy(Icon[HostCount].icon, _newicon, ICONSIZE);
  HostCount++;

  strcpy(Icon[HostCount].name, "Network Selection");
  Icon[HostCount].mode = M_Networks;
  Icon[HostCount].host = 0;
  Icon[HostCount].port = 0;
  memcpy(Icon[HostCount].icon, _neticon, ICONSIZE);
  HostCount++;


}

#define SICONS 4
typedef struct {
  char name[MAXNAME];
  u16 *icon;
} stockent;
stockent StockIcon[SICONS] = {
 { "MacOS", _macicon },
 { "Windows", _winicon },
 { "Linux", _tuxicon },
 { "Xbox", _xbxicon },
};

void MenuBlob(int f) {
  float scale = 1.5f;
  bltrect sel = { 0,  0, 64, 64, 64, 64, _menusel, scale, GE_TPSM_4444 };
  pgBitBltRM(&sel, 241-(32*scale), 97-(32*scale), AY8(GREY32[(f/2)&0x1f]/2,0xff));
}

void IconChooser() {
  int x, w, px, s = 0, f=0;
  u32 c;

  while(!bQuit && !bDisconnected) {
    f++;
    pgStartFrame();
    dlg_frame("\tPick Host Icon", " /  Enter");

//    pgFillBox(240-34, 62, 240+34, 130, WHITE);
    MenuBlob(f);

    for(px=0; px<3; px++) {
      bltrect ir;
      x = px + s - 1;
      if(x>=0 && x<SICONS) {
        w = strlen(StockIcon[x].name)*5;
        if(x==s) c = WHITE;
        else c = AY8(0x7f, 0x7f);
        mh_print(px*128+112-(w/2), 140, StockIcon[x].name, c);
        ir.u1 = ir.v1 = 0;
        ir.u2 = ir.v2 = 64;
        ir.tw = ir.th = 64;
        ir.b = StockIcon[x].icon;
        ir.f = GE_TPSM_4444;
        ir.s = 1;
        pgBitBltRM(&ir, px*128+80, 64, c);
      }
    }

    pgEndFrame();

    readpad(0);

    if(new_pad & PSP_CTRL_RIGHT) s++;
    if(new_pad & PSP_CTRL_LEFT) s--;

    if(s<0) s=SICONS-1;
    if(s>=SICONS) s=0;

    if(new_pad & (PSP_CTRL_CIRCLE | PSP_CTRL_CROSS)) {
      pickicon = s;
      return;
    }
  }
}
#endif

#define FIXPATH(x,y,z) { char *s; while((s = strchr(x,y))) s[0]=z; }

void SaveHost(char *path) {
  int fd;
  char temppath[MAXPATH];
  char name[MAXNAME];

  if(!path) return;

  memset(name, 0, MAXNAME);
  strcpy(name, path);

// don't allow users to use these chars.  
  FIXPATH(path, '/', '_');  FIXPATH(path, '=', '_');
  FIXPATH(path, '!', '_');  FIXPATH(path, '?', '_');
  FIXPATH(path, '*', '_');  FIXPATH(path, '\\', '_');
  FIXPATH(path, '|', '_');  FIXPATH(path, ':', '_');
  FIXPATH(path, ';', '_');  FIXPATH(path, '<', '_');
  FIXPATH(path, '>', '_');  FIXPATH(path, '`', '_');
  FIXPATH(path, '~', '_');  FIXPATH(path, '"', '_');
  FIXPATH(path, '\'', '_'); FIXPATH(path, '+', '_');

  strcpy(temppath, VNCPath);
  strcat(temppath, "hosts/");
  strcat(temppath, path);
  
  fd = sceIoOpen(temppath, PSP_O_CREAT|PSP_O_RDWR|PSP_O_TRUNC, 0777);
  
  sceIoWrite(fd, &IP_h, 4);
  sceIoWrite(fd, &IP_p, 2);
  sceIoWrite(fd, name, MAXNAME);
  sceIoWrite(fd, (u8*)StockIcon[pickicon].icon, ICONSIZE);
  sceIoClose(fd);
}

void IP_Render(int s, int x, int y) {
    char HostText[] = "\t000.000.000.000:00000";

    sprintf(HostText, "\t%3i.%3i.%3i.%3i:%5i", (IP_h>>24), (IP_h>>16)&0xff, (IP_h>>8)&0xff, IP_h&0xff, IP_p);

    if(s<12) { // convert packed to dotted
      int g = s / 3;
      int d = s % 3;
      s=g*4+d;
    } else {
      s+=4;
    }

    mh_print(x*10,y*20,HostText, WHITE);
    mh_print((x+s)*10,(y+1)*20,"\t^", RED);
}

void IP_Minus(int s) {
  long b, g, d = 100;
  if(s<12) {
    g = s / 3;
    s %= 3;
    while(s) { d/=10; s--; }
  
    b = (IP_h>>((3-g)*8))&0xff;
    IP_h &= ~(0xff<<((3-g)*8));
    if (b-d>=0) b-=d;
    else b=0;
    IP_h |= b<<((3-g)*8);
  } else {
    s -= 12;    
    d = 10000;
    while(s) { d/=10; s--; }
  
    if (IP_p-d>=0) IP_p-=d;
    else IP_p = 0;
  }
}

void IP_Plus(int s) {
  long b, g, d = 100;
  if(s<12) {
    g = s / 3;
    s %= 3;
    while(s) { d/=10; s--; }
  
    b = (IP_h>>((3-g)*8))&0xff;
    IP_h &= ~(0xff<<((3-g)*8));
    if (b+d<=0xff) b+=d;
    else b = 0xff;
    IP_h |= b<<((3-g)*8);
  } else {
    s -= 12;    
    d = 10000;
    while(s) { d/=10; s--; }
  
    if (IP_p-d<=0xffff) IP_p+=d;
    else IP_p = 0xffff;
  }
}

void IP_ParseInput() {
  readpad(0);

  if(new_pad & PSP_CTRL_DOWN) IP_Minus(IP_s);
  if(new_pad & PSP_CTRL_UP) IP_Plus(IP_s);
  if(new_pad & PSP_CTRL_LEFT) IP_s--;
  if(new_pad & PSP_CTRL_RIGHT) IP_s++;

  if(IP_s<0) IP_s=16;
  if(IP_s>16) IP_s=0;

  if(new_pad & (PSP_CTRL_CIRCLE | PSP_CTRL_CROSS)) { IP_Done=2; };
  if(new_pad & PSP_CTRL_SQUARE) { IP_Done=1; };

}

void IP_Menu() {
  IP_Done = 0;
  IP_s = 0;

  while(!IP_Done && !bQuit && !bDisconnected) {
    pgStartFrame();

    dlg_frame("\tHost:"," /  Save   Cancel");
    IP_Render(IP_s,4,8);

    pgEndFrame();
    IP_ParseInput();
  }

  if(IP_Done==2) {
    if(!VKB_InputText("Filename?", hostfn, 32)) return;
#ifdef ICONLIST
    IconChooser();
    SaveHost(hostfn);
#else
    SaveHost(hostfn);
  } else {
    LoadHost(hostfn);
#endif
  }
}

char MenuText[5][16] = {
  "\tNew Host",
  "\tLoad Host File",
  "\tEdit Host File",
  "\tConnect",
  "\tExit"
};

int MainMenu_s = 1;

#ifndef ICONLIST
void vncMenu() {
  int y;

  while(!bQuit && !bDisconnected) {
    char HostText[] = "\t000.000.000.000:00000";

    pgStartFrame();

    dlg_frame(hostpath, " /  Enter");

    for(y=0; y<=4; y++) {
      if(y==MainMenu_s) {
        mh_print(48, y*20+48, MenuText[y], WHITE);
        mh_print(34, y*20+50, "\t>", WHITE);
      } else {
        mh_print(48, y*20+48, MenuText[y], GREY);
      }
    }

    sprintf(HostText, "\t%3i.%3i.%3i.%3i:%5i", (IP_h>>24), (IP_h>>16)&0xff, (IP_h>>8)&0xff, IP_h&0xff, IP_p);

    mh_print(48, 200, HostText, WHITE);

    pgEndFrame();

    readpad(0);

    if(new_pad & PSP_CTRL_DOWN) MainMenu_s++;
    if(new_pad & PSP_CTRL_UP) MainMenu_s--;

    if(MainMenu_s<0) MainMenu_s=3;
    if(MainMenu_s>4) MainMenu_s=0;

    if(new_pad & (PSP_CTRL_CIRCLE | PSP_CTRL_CROSS)) {
      switch(MainMenu_s) {
        case 0: {
          strcpy(hostfn, "NewHost");
          IP_Menu();
          strcpy(hostpath, VNCPath);
          strcat(hostpath, "Hosts/");
          strcat(hostpath, hostfn);
          break;
        }
        case 1: {
          if(getFilePath(hostpath))
            LoadHost(hostpath);
          break;
        }
        case 2: {
          if(hostpath[0]) {
            char *hp = strrchr(hostpath, '/');
            if(hp)
              strcpy(hostfn, hp+1);
            else
              strcpy(hostfn, hostpath);
            IP_Menu();
          }
          break;
        }
        case 3: {
          DB_ServerConnection srv;
          if(!hostfn) break;

          memset(&srv, 0, sizeof(DB_ServerConnection));
          srv.address = IP_h;
          srv.port = IP_p;
          srv.scaleFactor = 1;
          strncpy(srv.name, hostfn, 32);

          vncMain(&srv);
          break;
        }
        case 4: PostProgressMessage("\tExiting PSP VNC\t", 0, 4); return;
      }
    }
  }
}
#else
void vncMenu() {
  int x, w, px, s = 1, f=0;
  u32 c;

  for(x=0; x<MAXICON; x++) 
    memcpy(Icon[x].icon, _newicon, ICONSIZE);
  LoadHosts();
  LoadOptions();

  while(!bQuit && !bDisconnected) {
    f++;
    char msg[MAXPATH];
    sprintf(msg, "\tPortableVNC : %i Hosts Loaded", HostCount-3);

    pgStartFrame();
    dlg_frame(msg, " /  Enter   Delete   Edit");

//    pgFillBox(240-34, 62, 240+34, 130, WHITE);
    MenuBlob(f);

    for(px=0; px<3; px++) {
      bltrect ir;
      x = px + s - 1;
      if(x>=0 && x<HostCount) {
        int wh;
        char hostport[64];
        switch(Icon[x].port) {
          case 0x0000:
            strcpy(hostport, "");
            break;
          case 0xffff:
            strcpy(hostport, "");
            break;
          default:
            sprintf(hostport, "%i.%i.%i.%i:%i", (Icon[x].host>>24)&0xff, (Icon[x].host>>16)&0xff, (Icon[x].host>>8)&0xff, Icon[x].host&0xff, Icon[x].port);
        }
        w = strlen(Icon[x].name)*5;
        wh = strlen(hostport)*5;
        if(x==s) c = WHITE;
        else c = AY8(0x7f, 0x7f);
        mh_print(px*128+112-(w/2), 140, Icon[x].name, c);
        mh_print(px*128+112-(wh/2), 148, hostport, c);
        ir.u1 = ir.v1 = 0;
        ir.u2 = ir.v2 = 64;
        ir.tw = ir.th = 64;
        ir.b = Icon[x].icon;
        ir.f = GE_TPSM_4444;
        ir.s = 1;
        pgBitBltRM(&ir, px*128+80, 64, c);
      }
    }

    pgEndFrame();

    readpad(0);

    if(new_pad & PSP_CTRL_RIGHT) s++;
    if(new_pad & PSP_CTRL_LEFT) s--;

    if(s<0) s=HostCount-1;
    if(s>=HostCount) s=0;

    if((new_pad & PSP_CTRL_TRIANGLE) && s && (s<HostCount-1)) {
      int y = MsgPrintf(1, "Are you sure you wish to delete '%s'?", Icon[s].name);
      if(y) {
        char hostfile[MAXPATH];
        strcpy(hostfile, VNCPath);
        strcat(hostfile, "Hosts/");
        strcat(hostfile, Icon[s].name);
        sceIoRemove(hostfile);
      }
      LoadHosts();
    }

    if((new_pad & PSP_CTRL_SQUARE) && s && (s<HostCount-1)) {
      memset(hostfn, 0, sizeof(hostfn));
      strcpy(hostfn, Icon[s].name);
      IP_h = Icon[s].host;
      IP_p = Icon[s].port;
      IP_i = Icon[s].icon;
      IP_Menu();
      LoadHosts();
    }

    if(new_pad & (PSP_CTRL_CIRCLE | PSP_CTRL_CROSS)) {
      switch(Icon[s].mode) {
        case M_Options:
          vncOptions();
          break;
        case M_NewHost:
          memset(hostfn, 0, sizeof(hostfn));
          strcpy(hostfn, "Untitled Host");
          IP_h = 0xc0a80001;
          IP_p = 5900;
          IP_i = NULL;
          IP_Menu();
          LoadHosts();
          break;
        case M_Host: {
          DB_ServerConnection srv;

          memset(&srv, 0, sizeof(DB_ServerConnection));
          srv.address = Icon[s].host;
          srv.port = Icon[s].port;
          srv.scaleFactor = 1;
          strncpy(srv.name, hostfn, 32);

          vncMain(&srv);
          break; }
        case M_Networks:
          return;
      }
    }
  }

}
#endif

u8 IgnoreServerVersion = 1;
u8 SetNoDelay = 1;
u8 ConnectTimeout = 1;
u8 UpdatePreventsPowersave = 0;
u8 mouseDS = 3;
u8 mouseAS = 3;
u8 EnableLogging = 0;

typedef struct Menu_s {
  char *text;
  u16 *icon[8];
  u8 *variable;
} Menu_t;

#define OPTIONS 7
Menu_t Option[OPTIONS] = {
 { "Ignore Server Version", { _nocheck, _check, NULL }, &IgnoreServerVersion },
 { "TCP NoDelay", { _nocheck, _check, NULL }, &SetNoDelay },
 { "Enable Logfile", { _nocheck, _check, NULL }, &EnableLogging },
 { "Connection Timeout", { _five, _ten, _fifteen, _twenty, NULL }, &ConnectTimeout },
 { "Update Prevents Powersave", { _nocheck, _check, NULL }, &UpdatePreventsPowersave },
 { "Digital Speed", { _gauge1, _gauge2, _gauge3, _gauge4, _gauge5, NULL }, &mouseDS },
 { "Analog Speed", { _gauge1, _gauge2, _gauge3, _gauge4, _gauge5, NULL }, &mouseAS },
};

void LoadOptions() {
  int i, fd;
  char fn[MAXPATH];

  strcpy(fn, VNCPath);
  strcat(fn, "Options.dat");

  fd = sceIoOpen(fn, PSP_O_RDONLY, 0777);
  if(fd) {
    for(i=0; i<OPTIONS; i++) {
      if(Option[i].variable)
        sceIoRead(fd, Option[i].variable, 1);
        if(!Option[i].icon[*Option[i].variable]) *Option[i].variable=0;
    }
    sceIoClose(fd);
  }
}

void SaveOptions() {
  int i, fd;
  char fn[MAXPATH];

  strcpy(fn, VNCPath);
  strcat(fn, "Options.dat");

  fd = sceIoOpen(fn, PSP_O_CREAT|PSP_O_RDWR|PSP_O_TRUNC, 0777);
  if(fd) {
    for(i=0; i<OPTIONS; i++) {
      if(Option[i].variable)
        sceIoWrite(fd, Option[i].variable, 1);
    }
    sceIoClose(fd);
  }
}

void vncOptions() {
  int x, w, px, s = 0, f=0;
  u32 c;

  while(!bQuit && !bDisconnected) {
    f++;
    pgStartFrame();
    dlg_frame("\tPortableVNC Options", " /  Enter   /  Back");

//    pgFillBox(240-34, 62, 240+34, 130, WHITE);
    MenuBlob(f);

    for(px=0; px<3; px++) {
      bltrect ir;
      x = px + s - 1;
      if(x>=0 && x<OPTIONS) {
        w = strlen(Option[x].text)*5;
        if(x==s) c = WHITE;
        else c = AY8(0x7f, 0x7f);
        mh_print(px*128+112-(w/2), 140, Option[x].text, c);
        ir.u1 = ir.v1 = 0;
        ir.u2 = ir.v2 = 64;
        ir.tw = ir.th = 64;
        ir.b = Option[x].icon[*Option[x].variable];
        ir.f = GE_TPSM_4444;
        ir.s = 1;
        pgBitBltRM(&ir, px*128+80, 64, c);
      }
    }

    pgEndFrame();

    readpad(0);

    if(new_pad & PSP_CTRL_RIGHT) s++;
    if(new_pad & PSP_CTRL_LEFT) s--;

    if(s<0) s=OPTIONS-1;
    if(s>=OPTIONS) s=0;

    if(new_pad & (PSP_CTRL_UP | PSP_CTRL_CROSS)) {
      Option[s].variable[0]++;
      if(!Option[s].icon[Option[s].variable[0]]) Option[s].variable[0] = 0;
    }
    if(new_pad & (PSP_CTRL_DOWN | PSP_CTRL_CIRCLE)) {
      if(Option[s].variable[0]==0)
        while(Option[s].icon[Option[s].variable[0]]) Option[s].variable[0]++;
      Option[s].variable[0]--;
    }
    if(new_pad & (PSP_CTRL_SQUARE | PSP_CTRL_TRIANGLE)) {
      SaveOptions();
      return;
    }
  }
}

#define MAXNET 8
typedef struct net_s {
  char name[128];
  char ssid[128];
  char ip[128];
  int cindex;
} net_t;

net_t Net[MAXNET];

#include "pspnet.h"
int pickConnection() {
  int x, w, wx, wy, px, s = 0, f=0;
  u32 c;
  char data[128];

  int iNetIndex, NetCount = 0;

  for (iNetIndex = 1; (NetCount < MAXNET) && (iNetIndex < 100); iNetIndex++) {
    if (sceUtilityCheckNetParam(iNetIndex) != 0)
      break;
      
    sceUtilityGetNetParam(iNetIndex, 0, Net[NetCount].name);
    sceUtilityGetNetParam(iNetIndex, 1, Net[NetCount].ssid);
    
    sceUtilityGetNetParam(iNetIndex, 4, data);
    if (data[0]) {
      sceUtilityGetNetParam(iNetIndex, 5, Net[NetCount].ip);
      Net[NetCount].cindex = iNetIndex;
      NetCount++;
    }
  }
  
  if(!NetCount) {
    MessageBox("\tNo Static Connections\nFound.  Please add one.", 0);
    return -1;
  }

  while(!bQuit && !bDisconnected) {
    f++;
    pgStartFrame();
    dlg_frame("\tNetwork Connections", " /  Enter");

//    pgFillBox(240-34, 62, 240+34, 130, WHITE);
    MenuBlob(f);

    for(px=0; px<3; px++) {
      bltrect ir;
      x = px + s - 1;
      if(x>=0 && x<NetCount) {
        w = strlen(Net[x].name)*5;
        wx = strlen(Net[x].ssid)*5;
        wy = strlen(Net[x].ip)*5;
        if(x==s) c = WHITE;
        else c = AY8(0x7f, 0x7f);
        mh_print(px*128+112-(w/2), 140, Net[x].name, c);
        mh_print(px*128+112-(wx/2), 150, Net[x].ssid, c);
        mh_print(px*128+112-(wy/2), 160, Net[x].ip, c);
        ir.u1 = ir.v1 = 0;
        ir.u2 = ir.v2 = 64;
        ir.tw = ir.th = 64;
        ir.b = _neticon;
        ir.f = GE_TPSM_4444;
        ir.s = 1;
        pgBitBltRM(&ir, px*128+80, 64, c);
      }
    }

    pgEndFrame();

    readpad(0);

    if(new_pad & PSP_CTRL_RIGHT) s++;
    if(new_pad & PSP_CTRL_LEFT) s--;

    if(s<0) s=NetCount-1;
    if(s>=NetCount) s=0;

    if(new_pad & (PSP_CTRL_CIRCLE | PSP_CTRL_CROSS)) {
      return Net[s].cindex;
    }
  }
  
  return -1;
}


typedef struct home_s {
  char *text;
  int mode;
  u16 *icon;
} home_t;

#define M_Disconnect 8
#define M_Keyboard 9
#define M_Gamepad 10
#define M_Scroll 11
#define M_Mouse 12
#define M_DSpeed 14
#define M_ASpeed 15
#define M_Quit 16

#define MAXHOME 8
home_t HomeMenu[MAXHOME] = {
 { "Exit PortableVNC", M_Quit, _homeicon },
 { "Disconnect", M_Disconnect, _disicon },
 { "Virtual Keyboard", M_Keyboard, _vkbicon },
 { "Game Mode", M_Gamepad, _dpadicon },
 { "Mouse Mode", M_Mouse, _mouseicon },
 { "Scroll Mode", M_Scroll, _scrollicon },
 { "Digital Speed", M_DSpeed, NULL },
 { "Analog Speed", M_ASpeed, NULL },
};

void vncHomeMenu(int *padmode, int *disconnect) {
  int x, w, px, s = 1, f=0;
  u32 c;

  while(!bQuit && !bDisconnected) {
    f++;
    pgStartFrame();
    dlg_frame("\tConnection Options", " /  Enter   /  Back");

//    pgFillBox(240-34, 62, 240+34, 130, WHITE);
    MenuBlob(f);

    for(px=0; px<3; px++) {
      bltrect ir;
      x = px + s - 1;
      if(x>=0 && x<MAXHOME) {
        w = strlen(HomeMenu[x].text)*5;
        if(x==s) c = WHITE;
        else c = AY8(0x7f, 0x7f);
        mh_print(px*128+112-(w/2), 140, HomeMenu[x].text, c);
        ir.u1 = ir.v1 = 0;
        ir.u2 = ir.v2 = 64;
        ir.tw = ir.th = 64;
        if(HomeMenu[x].icon)
          ir.b = HomeMenu[x].icon;
        else if(HomeMenu[x].mode==M_DSpeed)
          ir.b = gauge[mouseDS];
        else if(HomeMenu[x].mode==M_ASpeed)
          ir.b = gauge[mouseAS];
        else
          ir.b = _unkicon;
        ir.f = GE_TPSM_4444;
        ir.s = 1;
        pgBitBltRM(&ir, px*128+80, 64, c);
      }
    }

    pgEndFrame();

    readpad(1);

    if(new_pad & PSP_CTRL_RIGHT) s++;
    if(new_pad & PSP_CTRL_LEFT) s--;

    if(s<0) s=MAXHOME-1;
    if(s>=MAXHOME) s=0;

    if(new_pad & (PSP_CTRL_CIRCLE | PSP_CTRL_CROSS)) {
      switch(HomeMenu[s].mode) {
        case M_Disconnect:
          *disconnect=1;
          return;
        case M_Quit:
          *disconnect=1;
          bQuit=1;
          return;
        case M_Gamepad:
          *padmode=3;
          return;
        case M_Keyboard:
          *padmode=2;
          return;
        case M_Mouse:
          *padmode=0;
          return;
        case M_Scroll:
          *padmode=1;
          return;
        case M_DSpeed:
          if(new_pad & PSP_CTRL_CIRCLE) {
            if(mouseDS==0) mouseDS=4;
            else mouseDS--;
          } else {
            mouseDS++;
          }
          if(mouseDS>4) mouseDS=0;
          break;
        case M_ASpeed:
          if(new_pad & PSP_CTRL_CIRCLE) {
            if(mouseAS==0) mouseAS=4;
            else mouseAS--;
          } else {
            mouseAS++;
          }
          if(mouseAS>4) mouseAS=0;
          break;
      }
    }
    if(new_pad & (PSP_CTRL_UP | PSP_CTRL_DOWN)) {
      switch(HomeMenu[s].mode) {
        case M_DSpeed:
          if(new_pad & PSP_CTRL_DOWN) {
            if(mouseDS==0) mouseDS=4;
            else mouseDS--;
          } else {
            mouseDS++;
          }
          if(mouseDS>4) mouseDS=0;
          break;
        case M_ASpeed:
          if(new_pad & PSP_CTRL_DOWN) {
            if(mouseAS==0) mouseAS=4;
            else mouseAS--;
          } else {
            mouseAS++;
          }
          if(mouseAS>4) mouseAS=0;
          break;
      }
    }
    if(new_pad & (PSP_CTRL_SQUARE | PSP_CTRL_TRIANGLE | PSP_CTRL_HOME)) {
      return;
    }
  }
}
