#include <stdio.h>

#define RGB(r,g,b) ( ((b<<8) & 0xf800) | ((g<<3) & 0x7e0) | ((r>>3) & 0x1f) )


int main(int argc, char **argv) {
  FILE *fpin, *fpout;
  int r,g,b,x,y;
  unsigned short o;
  
  if(argc<3) {
    printf("Syntax: %s <in.24> <out.16>\r\n", argv[0]);
    return 0;
  }
  
  fpin = fopen(argv[1], "rb");
  fpout = fopen(argv[2], "wb");

  if(!fpin)  { printf("%s: Unable to open '%s'\r\n", argv[0], argv[1]); return -1; } 
  if(!fpout) { printf("%s: Unable to open '%s'\r\n", argv[0], argv[2]); return -1; } 
   
  for(y = 0; y<272; y++) {
    for(x = 0; x<480; x++) {
      r = fgetc(fpin);
      g = fgetc(fpin);
      b = fgetc(fpin);
      o = RGB(r,g,b);
      fwrite(&o, 1, 2, fpout);
    }
  }
  
  fclose(fpin);
  fclose(fpout);

  return 0;
}

