#include <stdio.h>

#define ARGB(a,r,g,b) ( ((a<<8) & 0xf000) | ((b<<4) & 0xf00) | (g & 0xf0) | ((r>>4) & 0xf) )

int main(int argc, char **argv) {
  FILE *fpina, *fpinrgb, *fpout;
  int A,x,y,r,g,b;
  unsigned short o;
  
  if(argc<4) {
    printf("Syntax: %s <in.alpha> <in.rgb> <out.16>\r\n", argv[0]);
    return 0;
  }
  
  fpina = fopen(argv[1], "rb");
  fpinrgb = fopen(argv[2], "rb");
  fpout = fopen(argv[3], "wb");

  if(!fpina)  { printf("%s: Unable to open '%s'\r\n", argv[0], argv[1]); return -1; } 
  if(!fpinrgb)  { printf("%s: Unable to open '%s'\r\n", argv[0], argv[2]); return -1; } 
  if(!fpout) { printf("%s: Unable to open '%s'\r\n", argv[0], argv[3]); return -1; } 
   
  for(y = 0; y<272; y++) {
    for(x = 0; x<480; x++) {
      A = fgetc(fpina);
      r = fgetc(fpinrgb);
      g = fgetc(fpinrgb);
      b = fgetc(fpinrgb);
      o = ARGB(A,r,g,b);
      fwrite(&o, 1, 2, fpout);
    }
  }
  
  fclose(fpina);
  fclose(fpinrgb);
  fclose(fpout);

  return 0;
}

