//  Copyright (C) 2000 Tridia Corporation. All Rights Reserved.
//  Copyright (C) 1999 AT&T Laboratories Cambridge. All Rights Reserved.
//
//  This file is part of the VNC system.
//
//  The VNC system is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
//  USA.
//
// TightVNC distribution homepage on the Web: http://www.tightvnc.com/
//
// If the source code for the VNC system is not available from the place 
// whence you received this file, check http://www.uk.research.att.com/vnc or contact
// the authors on vnc@uk.research.att.com for information on obtaining it.

// Raw Encoding
//
#include <pspkernel.h>
#include <string.h>
#include "pspnet.h"
#include "vnc.h"

extern int rfbsock;

extern CARD8 m_netbuf[0x80000];

#define CheckBufferSize(x) if(x>sizeof(m_netbuf)) return false;
#define Check_Rectangle_borders(x,y,w,h)

int ReadRawRect(rfbFramebufferUpdateRectHeader *pfburh) {
  unsigned int numpixels = pfburh->r.w * pfburh->r.h;
  // this assumes at least one byte per pixel. Naughty.
  unsigned int numRawBytes = numpixels * 2;

  // Read in the compressed data
  CheckBufferSize(numRawBytes);

  ReadExact(rfbsock, m_netbuf, numRawBytes);

  CopyDataToScreen((CARD16*)m_netbuf, pfburh->r.x, pfburh->r.y, pfburh->r.w,pfburh->r.h);

  return true;
}

int ReadSolidRect(rfbFramebufferUpdateRectHeader *pfburh) {
//  unsigned int numpixels = pfburh->r.w * pfburh->r.h;
  // this assumes at least one byte per pixel. Naughty.
  unsigned int numRawBytes = 2;

  // Read in the compressed data
  CheckBufferSize(numRawBytes);

  ReadExact(rfbsock, m_netbuf, numRawBytes);

  DrawVirtualFilledRectangle(*(CARD16*)m_netbuf, pfburh->r.x, pfburh->r.y, pfburh->r.w, pfburh->r.h, true);

  return true;
}

