// primitive graphics for Hello World PSP

#include <pspkernel.h>
#include <pspdisplay.h>
#include <pspctrl.h>
#include <psppower.h>
#include <pspgu.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "pg.h"

extern u16 _font[128*128];
extern u16 _font2[256*256];
extern u16 _buttons[64*16];

struct Vertex
{
        float u, v;
        u32 color;
        float x, y, z;
};

struct NVertex
{
        float x, y, z;
};


#define SLICE_SIZE 64 // change this to experiment with different page-cache sizes
static unsigned int __attribute__((aligned(16))) list[262144];

int Lx=0, Ly=0;

extern u16 _plugbmp[];

int HomeVisible=0;

//system call

extern u8 GREY32[32];


void pgWaitVn(u32 count)
{
	for (; count>0; --count) {
		sceDisplayWaitVblankStart();
	}
}


void pgWaitV()
{
	sceDisplayWaitVblankStart();
}

void pgInit()
{
  sceGuInit();

  // setup
  sceGuStart(0,list);
  sceGuDrawBuffer(GE_PSM_8888,(void*)0,512);
  sceGuDispBuffer(480,272,(void*)0x88000,512);
  sceGuDepthBuffer((void*)0x110000,512);
  sceGuOffset(2048 - (480/2),2048 - (272/2));
  sceGuViewport(2048,2048,480,272);
  sceGuDepthRange(0xc350,0x2710);  
  sceGuScissor(0,0,480,272);
  sceGuEnable(GU_STATE_SCISSOR);
  sceGuFrontFace(GE_FACE_CW);   
  sceGuEnable(GU_STATE_TEXTURE);
  sceGuClear(GE_CLEAR_COLOR|GE_CLEAR_DEPTH);
  sceGuFinish();
  sceGuSync(0,0);

//  sceDisplayWaitVblankStart();
  sceGuDisplay(1);
}

void pgDrawFrame(unsigned long x1, unsigned long y1, unsigned long x2, unsigned long y2, unsigned long color)
{
  unsigned long i;
  unsigned long x[8] = { x1,   x2,     x1, x2,   x1, x1+1,   x2-1, x2 };
  unsigned long y[8] = { y1, y1+1,   y2-1, y2,   y1,   y2,     y1, y2 };
  u32 alpha = color | 0xffffff;

  sceGuDisable(GU_STATE_TEXTURE);
  sceGuColor(color);

  sceGuEnable(GU_STATE_ALPHA);
  sceGuBlendFunc(GE_ALPHA_ADD, GE_ALPHA_FIX, GE_ALPHA_FIX, alpha, 0xff000000-alpha);

  for (i = 0; i < 8; i+=2)
  {
    struct NVertex* vertices = (struct NVertex*)sceGuGetMemory(2 * sizeof(struct NVertex));

    vertices[0].x = x[i]; vertices[0].y = y[i]; vertices[0].z = 0;
    vertices[1].x = x[i+1]; vertices[1].y = y[i+1]; vertices[1].z = 0;  

    sceGuDrawArray(GU_PRIM_SPRITES,GE_SETREG_VTYPE(GE_TT_NONE,GE_CT_NONE, 0,GE_MT_32BITF,0,0,0,0,GE_BM_2D),2,0,vertices);
  }
}

void pgFillBox(unsigned long x1, unsigned long y1, unsigned long x2, unsigned long y2, unsigned long color)
{
  u32 alpha = color | 0xffffff;

  sceGuDisable(GU_STATE_TEXTURE);
  sceGuColor(color);

  sceGuEnable(GU_STATE_ALPHA);
  sceGuBlendFunc(GE_ALPHA_ADD, GE_ALPHA_FIX, GE_ALPHA_FIX, alpha, 0xff000000-alpha);

  struct NVertex* vertices = (struct NVertex*)sceGuGetMemory(2 * sizeof(struct NVertex));

  vertices[0].x = x1; vertices[0].y = y1; vertices[0].z = 0;
  vertices[1].x = x2; vertices[1].y = y2; vertices[1].z = 0;

  sceGuDrawArray(GU_PRIM_SPRITES,GE_SETREG_VTYPE(GE_TT_NONE,GE_CT_NONE, 0,GE_MT_32BITF,0,0,0,0,GE_BM_2D),2,0,vertices);
}

void pgFillvram(u32 color)
{
    pgFillBox(0, 0, 479, 271, color);
}

void pgBitBltRM(bltrect *sr, u16 dx, u16 dy, u32 col) {
  int w=sr->u2 - sr->u1;
  int h=sr->v2 - sr->v1;
  if(sr->s < -1) {
    w/=(- sr->s);
    h/=(- sr->s);
  } else if(sr->s>1) {
    w*=sr->s;
    h*=sr->s;
  }

  sceGuEnable(GU_STATE_TEXTURE);

  sceGuEnable(GU_STATE_ALPHA);
  sceGuBlendFunc(GE_ALPHA_ADD, GE_ALPHA_SRC_ALPHA, GE_ALPHA_ONE_MINUS_SRC_ALPHA, 0, 0);

  sceGuTexMode(sr->f,0,0,0);
  sceGuTexImage(0,sr->tw,sr->th,sr->tw,sr->b);
  if(sr->f==GE_TPSM_4444)
    sceGuTexFunc(GE_TFX_MODULATE,GE_TCC_RGBA);
  else
    sceGuTexFunc(GE_TFX_MODULATE,GE_TCC_RGB);
  sceGuTexFilter(GE_FILTER_LINEAR,GE_FILTER_LINEAR);
  sceGuTexScale(1.0f/(sr->tw*1.0f),1.0f/(sr->th*1.0f));
  sceGuTexOffset(0,0);

  sceGuAmbientColor(0xffffffff);
  sceGuColor(0xffffffff);

  struct Vertex* vertices = (struct Vertex*)sceGuGetMemory(2 * sizeof(struct Vertex));

  vertices[0].u = sr->u1; vertices[0].v = sr->v1;
  vertices[0].x = dx; vertices[0].y = dy; vertices[0].z = 0;
  vertices[0].color = vertices[1].color = col;
  vertices[1].u = sr->u2; vertices[1].v = sr->v2;
  vertices[1].x = dx+w; vertices[1].y = dy+h; vertices[1].z = 0;  

  sceGuDrawArray(GU_PRIM_SPRITES,GE_SETREG_VTYPE(GE_TT_32BITF,GE_CT_8888, 0,GE_MT_32BITF,0,0,0,0,GE_BM_2D),2,0,vertices);
}

void memmove1(void *odb, void *osb, u32 size) {
  int i;

  u8 *db=(u8*)odb;
  u8 *sb=(u8*)osb;
  if(db>sb) {
    for(i=size-1; i>=0; i--) db[i]=sb[i];
  } else {
    for(i=0; i<size; i++) db[i]=sb[i];
  }
}

void memmove2(void *odb, void *osb, u32 size) {
  int i;

  if((u32)odb & 0x1) { memmove1(odb, osb, size); return; }
  if((u32)osb & 0x1) { memmove1(odb, osb, size); return; }
  if(size & 0x1) { memmove1(odb, osb, size); return; }

  u16 *db=(u16*)odb;
  u16 *sb=(u16*)osb;
  size/=2;
  if(db>sb) {
    for(i=size-1; i>=0; i--) db[i]=sb[i];
  } else {
    for(i=0; i<size; i++) db[i]=sb[i];
  }
}

void memmove4(void *odb, void *osb, u32 size) {
  int i;

  if((u32)odb & 0x1) { memmove1(odb, osb, size); return; }
  if((u32)osb & 0x1) { memmove1(odb, osb, size); return; }
  if(size & 0x1) { memmove1(odb, osb, size); return; }

  if((u32)odb & 0x2) { memmove2(odb, osb, size); return; }
  if((u32)osb & 0x2) { memmove2(odb, osb, size); return; }
  if(size & 0x2) { memmove2(odb, osb, size); return; }

  u32 *db=(u32*)odb;
  u32 *sb=(u32*)osb;
  size/=4;
  if(db>sb) {
    for(i=size-1; i>=0; i--) db[i]=sb[i];
  } else {
    for(i=0; i<size; i++) db[i]=sb[i];
  }
}

void pgBitBltD(u16 *db, u16 ds, u16 dx, u16 dy,
               u16 *sb, u16 ss, u16 sx, u16 sy, u16 sw, u16 sh) {
  short y; // x

  // dirx>0 start at left edge, else start at right
  // diry>0 start at top edge, else start at bottom

  if(sb && db) {
    sb+=sx+sy*ss;
    db+=dx+dy*ds;
    if(sy>dy) {
      for(y=0; y<sh; y++) memmove4(db+y*ds, sb+y*ds, sw*2);
//      if(sx>dx) {
//        for(y=0; y<sh; y++)
//          for(x=0; x<sw; x++)
//            db[x+y*ds] = sb[x+y*ss];
//      } else {
//        for(y=0; y<sh; y++)
//          for(x=sw-1; x>=0; x--)
//            db[x+y*ds] = sb[x+y*ss];
//      }
    } else {
      for(y=sh-1; y>=0; y--) memmove4(db+y*ds, sb+y*ds, sw*2);
//      if(sx>dx) {
//        for(y=sh-1; y>=0; y--)
//          for(x=0; x<sw; x++)
//            db[x+y*ds] = sb[x+y*ss];
//      } else {
//        for(y=sh-1; y>=0; y--)
//          for(x=sw-1; x>=0; x--)
//            db[x+y*ds] = sb[x+y*ss];
//      }
    }
  }
}

void pgStartFrame()
{
  sceKernelDcacheWritebackAll();
  sceGuStart(0,list);
  sceGuClearColor(0xff000000);
  sceGuClearDepth(0);
  sceGuClear(GE_CLEAR_COLOR|GE_CLEAR_DEPTH);
}

void pgEndFrame()
{
  sceGuFinish();
  sceGuSync(0,0);

//  sceDisplayWaitVblankStart();
  sceGuSwapBuffers();
}

// by kwn
void Draw_Char(int x,int y,const unsigned char c, u32 col, float scale) {
	unsigned char ch;
	bltrect fr;

	ch = c;

	// mapping
	if (ch<0x20)
		ch = 0;
	else if (ch<0x80)
		ch -= 0x20;
	else if (ch<0xa0)
		ch = 0;
	else
		ch -= 0x40;

        fr.u1 = (ch%16)*8;
        fr.v1 = (ch/16)*10;
        fr.u2 = fr.u1+5;
        fr.v2 = fr.v1+10;
        if(scale>=2) {
          fr.u1*=2;
          fr.u2*=2;
          fr.v1*=2;
          fr.v2*=2;
          fr.tw = 256;
          fr.th = 256;
          fr.b = _font2;
          fr.s = scale/2.0f;
        } else {
          fr.tw = 128;
          fr.th = 128;
          fr.b = _font;
          fr.s = scale;
        }
        fr.f = GE_TPSM_4444;
        
        pgBitBltRM(&fr, x, y, col);
}

// by kwn
void Draw_Button(int x,int y, unsigned char d, int scale) {
  bltrect fr;
  d &= 3;
  
  fr.u1 = d*16;
  fr.v1 = 0;
  fr.u2 = fr.u1+16;
  fr.v2 = 16;
  fr.tw = 64;
  fr.th = 16;
  fr.b = _buttons;
  fr.s = scale;
  fr.f = GE_TPSM_4444;
        
  pgBitBltR(&fr, x, y-3);
}

// by kwn
void mh_print(int x,int y,const char *msg, u32 col) {
        int xx = x;
        float scale = 1.0f;
        unsigned char ch = 0, *str=(unsigned char*)msg;

        while(*str != 0) {
                ch = *str++;
                if ((ch>=0x80) && (ch<0x84)) {
                  Draw_Button(x,y,ch,scale);
                  x+=16;
                } else if ((ch>=0x91) && (ch<0x94)) {
                  scale=ch-0x90;
                } else if (ch=='\t'){
                  scale+=1.0f;
                  if(scale>2.0f) scale=1.0f;
                } else if (ch=='\n'){
                  x=xx; 
                  y+=10*scale;
                } else {
                  Draw_Char(x,y,ch,col,scale);
                  x+=5*scale;
                }
                if (x>=480) break;
        }
}


void HomeScreen();

u32 now_pad, new_pad, old_pad;
SceCtrlData paddata;

void readpad(int HomeInhibit)
{
        static int n=0;

        sceCtrlSetSamplingCycle(0);
        sceCtrlSetSamplingMode(1);
        sceCtrlReadBufferPositive(&paddata, 1);
        // kmg
        // Analog pad state
        Lx = paddata.Lx;
        Ly = paddata.Ly;

#if 0        
        if (paddata.Ly == 0xff) paddata.Buttons=PSP_CTRL_DOWN;
        if (paddata.Ly == 0x00) paddata.Buttons=PSP_CTRL_UP;  
        if (paddata.Lx == 0x00) paddata.Buttons=PSP_CTRL_LEFT;
        if (paddata.Lx == 0xff) paddata.Buttons=PSP_CTRL_RIGHT;
#endif

        now_pad = paddata.Buttons;
        new_pad = now_pad & ~old_pad;
        if(old_pad==now_pad){
                n++;
                if(n>=25){
                        new_pad=now_pad;
                        n = 20;
                }
        }else{
                n=0;
                old_pad = now_pad;
        }
        
        if((new_pad & PSP_CTRL_HOME) && !HomeVisible && !HomeInhibit)
          HomeScreen();
}

extern int bQuit;
void HomeScreen() {
  int HomeSel=0;
  int x1=170, x2=480-226, c, f=0;
  HomeVisible=1;
  for(;;) {
    readpad(1);

    if(new_pad & (PSP_CTRL_LEFT | PSP_CTRL_RIGHT)) HomeSel = !HomeSel;
    if(new_pad & PSP_CTRL_HOME) break;
    if(new_pad & (PSP_CTRL_CROSS | PSP_CTRL_CIRCLE)) { bQuit = HomeSel; break; }
    if(new_pad & (PSP_CTRL_SQUARE | PSP_CTRL_TRIANGLE)) break;

    pgStartFrame();
    pgFillBox(0, 0, 479, 271, BLACK);

    mh_print(240-63, 271-15, " /  Enter   /  Back", BLACK);
    mh_print(240-64, 271-16, " /  Enter   /  Back", WHITE);

    pgFillBox(52, 90, 479-52, 91, RGB888(255,255,255));
//    pgFillBox(56, 92, 479-56, 152, RGB888(64,64,64));
    pgFillBox(52, 153, 479-52, 154, RGB888(255,255,255));

    mh_print(141,97,"\tDo you want to quit?", BLACK);
    mh_print(140,96,"\tDo you want to quit?", WHITE);

    f++;
    c = AY8(GREY32[(f & 0x1f)], GREY32[(f & 0x1f)]);

    if(HomeSel) {
      pgFillBox(x1, 122, x1+56, 146, c);
    } else {
      pgFillBox(x2, 122, x2+56, 146, c);
    }
    mh_print(x1+14, 126, "\tYES", BLACK);
    mh_print(x1+13, 125, "\tYES", WHITE);
    mh_print(x2+19, 126, "\tNO", BLACK);
    mh_print(x2+18, 125, "\tNO", WHITE);

    pgBattery(479-64, 4);

    pgEndFrame();
  }
  readpad(1);
  HomeVisible=0;
}

void pgBattery(int x, int y) {
  int l,w,r, bp, c;

  bp = scePowerGetBatteryLifePercent();

  l = x+3;
  w = 48;
  r = l+w+2;
  pgFillBox(x, y+8, l, y+16, WHITE);
  pgFillBox(l, y, r+3, y+24, WHITE);
  pgDrawFrame(l+1, y, r+2, y+23, WHITE);
  pgFillBox(l+2, y+2, r+1, y+22, BLACK);

  if(bp>80) c = WHITE;
  if(bp>60) c = GREEN;
  else if(bp>40) c = YELLOW;
  else if(bp>20) c = ORANGE;
  else c = RED;

  if(bp>=0) {
    char battmp[32];
    if(now_pad & PSP_CTRL_LTRIGGER)
      sprintf(battmp, "\t%iv", scePowerGetBatteryVolt());
    else
      sprintf(battmp, "\t%i", bp);
    pgFillBox(r - ((w*bp)/100), y+4, r, y+20, c);
    w+=x-(strlen(battmp)*5)/2-20;
    mh_print(w+1,8, battmp, BLACK);
    mh_print(w,7, battmp, WHITE);
  } else {
    w+=x-30;
    mh_print(w+1,8, "Wait", BLACK);
    mh_print(w,7, "Wait", WHITE);
  }

  if(scePowerIsPowerOnline()) {
    bltrect br = { 0, 0, 32, 32, 32, 32, _plugbmp, 1, GE_TPSM_4444 };
    pgBitBltR(&br, x-32, y);
  }
}
