#ifndef __PG_H
#define __PG_H

#include <pspgu.h>
#include <pspctrl.h>

// primitive graphics for Hello World PSP


#define AY8(a,y) ( (a<<24) | (y * 0x10101) )
#define RGB888(r,g,b) ( (b<<16)  | (g<<8) | (r) | 0xff000000 )
#define RGB444(r,g,b) ( ((b<<4)&0xf00)  | (g&0xf0) | ((r>>4)&0xf) | 0xf000 )
#define RGB565(r,g,b) ( ((b<<8) & 0xf800) | ((g<<3) & 0x7e0) | ((r>>3) & 0x1F) )

#define WHITE RGB888(255,255,255)
#define GREY  RGB888(127,127,127)
#define RED   RGB888(255,0,0)
#define GREEN RGB888(0,255,0)
#define BLUE  RGB888(0,0,255)
#define BLACK RGB888(0,0,0)
#define YELLOW RGB888(255,255,0)
#define ORANGE RGB888(255,127,0)
#define VIOLET RGB888(255,0,255)
#define TEAL RGB888(0,255,255)

int Lx, Ly;
 
typedef struct {
	u16 u1, v1;	// origin
	u16 u2, v2;	// clip size
	u16 tw, th;	// tex size
	u16 *b;		// buffer
	float s;	// scale
	u16 f;		// format
} bltrect;

u16 *pgGetVramAddr(u32 x,u32 y);
void pgInit();
void pgWaitV();
void pgWaitVn(u32 count);
void pgStartFrame();
void pgEndFrame();
void pgFillvram(u32 color);
void pgBitBltD(u16 *db, u16 ds, u16 dx, u16 dy,
               u16 *sb, u16 ss, u16 sx, u16 sy, u16 sw, u16 sh);
void pgBitBltRM(bltrect *sr, u16 dx, u16 dy, u32 col);
#define pgBitBltR(sr,dx,dy) pgBitBltRM(sr,dx,dy,WHITE)
void pgBitBlt(u32 x,u32 y,u32 w,u32 h,u32 mag,const u16 *d);

#define SCREEN_WIDTH  480
#define SCREEN_HEIGHT 272
#define         PIXELSIZE       1                               //in short
#define         LINESIZE        512                             //in short
#define         FRAMESIZE       0x44000                 //in byte
#define CMAX_X 60
#define CMAX_Y 34
#define CMAX2_X 30
#define CMAX2_Y 17
#define CMAX4_X 15
#define CMAX4_Y 8 

void readpad(int HomeInhibit);

extern u32 new_pad, now_pad, old_pad;
extern SceCtrlData paddata;

#define UPPER_THRESHOLD  0xcf
#define LOWER_THRESHOLD  0x2f

void pgBattery(int x, int y);
void pgDrawFrame(unsigned long x1, unsigned long y1, unsigned long x2, unsigned long y2, unsigned long color);
void pgFillBox(unsigned long x1, unsigned long y1, unsigned long x2, unsigned long y2, unsigned long color);
void mh_print(int x,int y,const char *msg, u32 col);

#endif
