#include <stdio.h>

int main( int argc, char **argv ) {
  FILE *fp;
  int i;

  if(argc<2) {
    printf("Syntax: %s <HostFile> <Host>:<Screen>\r\n", argv[0]);
    printf("\t\tHost is a dotted quad (192.168.0.1)\r\n");
    printf("\t\tScreen is a display or port number (0, 5900)\r\n");
    printf("\t\t\tAny number over 3 is treated as a port\r\n");
    return 0;
  }

  if(argc>2) {
    fp = fopen(argv[1], "wb");
  
    {
      int a,b,c,d,e;
      sscanf(argv[2], "%d.%d.%d.%d:%d", &a, &b, &c, &d, &e);
      fputc(d, fp); fputc(c, fp); fputc(b, fp); fputc(a, fp);
      if(e<4) e+=5900;
      fputc((e&0xff), fp); fputc((e>>8), fp);
    }
  } else {
    fp = fopen(argv[1], "rb");
    
    {
      int a,b,c,d,e;
      d=fgetc(fp);
      c=fgetc(fp);
      b=fgetc(fp);
      a=fgetc(fp);
      e=fgetc(fp) | (fgetc(fp)<<8);
      printf("%d.%d.%d.%d:%d\n", a, b, c, d, e);
    }
  }

  fclose(fp);
}

